/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.tags.hmc;

import com.ibm.hwmca.fw.servlet.graphics.PieChart;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.tagext.TagSupport;

public class PieChartHandler
extends TagSupport {
    private static final String TRACE_MASK = "XTAGPIE";
    private static final String TRACE_MASKD = "XTAGPIED";
    private static final String TRACE_MASKF = "XTAGPIEF";
    private static final String TRACE_MASKT = "XTAGPIET";
    private int size;
    private int defaultChartColor;
    private List percentages;
    private List colors;

    public int doStartTag() {
        this.percentages = new ArrayList();
        this.colors = new ArrayList();
        return 1;
    }

    public int doEndTag() {
        int i;
        double[] percentagesArray = new double[this.percentages.size()];
        int[] colorsArray = new int[this.colors.size() + 1];
        for (i = 0; i < percentagesArray.length; ++i) {
            percentagesArray[i] = (Double)this.percentages.get(i);
        }
        for (i = 0; i < colorsArray.length - 1; ++i) {
            colorsArray[i] = (Integer)this.colors.get(i);
        }
        colorsArray[colorsArray.length - 1] = this.defaultChartColor;
        String uri = PieChart.buildURI(colorsArray, percentagesArray, this.size);
        try {
            this.pageContext.getOut().print("<img src=\"" + uri + "\"/>");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return 6;
    }

    public void setSize(String sizeString) {
        Trace.trace(TRACE_MASKT, "-> setSize(" + sizeString + ")");
        if (sizeString == null || sizeString.equals("")) {
            throw new IllegalArgumentException("sizeString argument must be non-null & non-empty");
        }
        try {
            this.size = Integer.parseInt(sizeString.trim());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("sizeString argument must be an integer value: " + sizeString);
        }
        if (this.size <= 0) {
            throw new IllegalArgumentException("sizeString must be greater than 0: " + this.size);
        }
        Trace.trace(TRACE_MASKT, "<- setSize(" + sizeString + ")");
    }

    public void setDefaultChartColor(String defaultChartColorString) {
        Trace.trace(TRACE_MASKT, "-> setDefaultChartColor(" + defaultChartColorString + ")");
        if (defaultChartColorString == null || defaultChartColorString.equals("")) {
            throw new IllegalArgumentException("defaultChartColorString argument must be non-null & non-empty");
        }
        try {
            this.defaultChartColor = Integer.decode(defaultChartColorString.trim());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("defaultChartColorString argument must be an integer value: " + defaultChartColorString);
        }
        if (this.defaultChartColor < 0) {
            throw new IllegalArgumentException("defaultChartColor must be greater than or equal to 0: " + this.defaultChartColor);
        }
        Trace.trace(TRACE_MASKT, "<- setDefaultChartColor(" + defaultChartColorString + ")");
    }

    protected void addSlice(double percentage, int color) {
        this.percentages.add(new Double(percentage));
        this.colors.add(new Integer(color));
    }
}

